package com.ejie.ab04b.service;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.temp.DocumentosAperturasTempDao;
import com.ejie.ab04b.dao.temp.DocumentosOS2TempDao;
import com.ejie.ab04b.dao.temp.DocumentosOS3TempDao;
import com.ejie.ab04b.dao.xa.SolicAperturasDaoXA;
import com.ejie.ab04b.dao.xa.SolicDocumentosDaoXA;
import com.ejie.ab04b.dao.xa.SolicOS2DaoXA;
import com.ejie.ab04b.dao.xa.SolicOS3DaoXA;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.DocumentoAperturas;
import com.ejie.ab04b.model.DocumentoOS2;
import com.ejie.ab04b.model.DocumentoOS3;
import com.ejie.ab04b.model.OS2;
import com.ejie.ab04b.model.OS3;
import com.ejie.ab04b.model.TramiteOS2;
import com.ejie.ab04b.model.TramiteOS3;
import com.ejie.ab04b.util.Utilities;
import com.ejie.foldermanagement.xml.ContextSubmissionEvent;

/**
 * 
 * @author GFI-NORTE
 * 
 */
@Service(value = "consolidarEventoService")
public class ConsolidarEventoServiceImpl implements ConsolidarEventoService {

	private static final int TRANSACTION_TIMEOUT = 60;

	// private static final int MILIS_IN_A_MINUTE = 1000;
	// private static final int SLEEP_PLATEA_NUM_REG = 5;

	private static final Logger LOGGER = LoggerFactory
			.getLogger(ConsolidarEventoServiceImpl.class);

	// @Autowired()
	// private SolicAperturasDao solicAperturaDao;

	@Autowired()
	private SolicAperturasDaoXA solicAperturaDaoXA;

	// @Autowired()
	// private DocumentoAperturasCustomDao documentoAperturasDao;

	@Autowired()
	private SolicDocumentosDaoXA solicDocumentosDaoXA;

	// @Autowired()
	// private DokusiService dokusiService;

	@Autowired()
	private ComunicacionAperturaService comunicacionAperturaService;

	@Autowired()
	private OS2Service os2Service;

	@Autowired()
	private OS3Service os3Service;

	@Autowired()
	private DocumentosAperturasTempDao documentosAperturasTempDao;

	@Autowired()
	private DocumentosOS2TempDao documentosOS2TempDao;

	@Autowired()
	private DocumentosOS3TempDao documentosOS3TempDao;

	// @Autowired()
	// private SolicOS2Dao solicOS2Dao;

	@Autowired()
	private SolicOS2DaoXA solicOS2DaoXA;

	// @Autowired()
	// private DocumentoOS2CustomDao documentoOS2Dao;

	// @Autowired()
	// private SolicOS3Dao solicOS3Dao;

	@Autowired()
	private SolicOS3DaoXA solicOS3DaoXA;

	// @Autowired()
	// private DocumentoOS3CustomDao documentoOS3Dao;

	// @Autowired()
	// private Properties appConfiguration;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab04b.service.ConsolidarEventoService#
	 * consolidarEventoSolTelematicaApertura(com.ejie.foldermanagement.xml.
	 * ContextSubmissionEvent, java.lang.Long)
	 */
	@Override()
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED, rollbackFor = Throwable.class, timeout = ConsolidarEventoServiceImpl.TRANSACTION_TIMEOUT)
	public void consolidarEventoSolTelematicaApertura(
			ContextSubmissionEvent contextSubmission, Long idTramite)
			throws AB04BException {
		/*
		 * try { ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--" +
		 * Utilities.obtenerCadena("El procedureId es ",
		 * contextSubmission.getProcedureID()));
		 * 
		 * this.initXaTransaction();
		 * 
		 * // Dormimos la ejecución porque en ocasiones el evento R02_REQUEST //
		 * llega // antes que la respuesta de Platea y en ese caso hará la
		 * consulta // findSolicitudByNumRegistro antes de que la L61A haya
		 * guardado el // número de registro en la tabla de Solicitudes, por lo
		 * que no // encontrará ninguna fila que corresponda al número de
		 * registro del // evento
		 * 
		 * Thread.sleep(ConsolidarEventoServiceImpl.SLEEP_PLATEA_NUM_REG,
		 * ConsolidarEventoServiceImpl.MILIS_IN_A_MINUTE);
		 * 
		 * if (contextSubmission.getProcedureID().equals(
		 * Utilities.getInstance().obtenerProcedureIdApertura())) {
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEventoFront -- "
		 * + "Es procedure Apertura");
		 * 
		 * // Actualizamos la solicitud ConsolidarEventoServiceImpl.LOGGER
		 * .info("consolidarEventoFront -- " + Utilities.obtenerCadena(
		 * "El número de registro es ", contextSubmission.getRegistryNumber()));
		 * 
		 * SolicAperturas solicitud = this.solicAperturaDao
		 * .findSolicitud(contextSubmission.getRegistryNumber()); if (solicitud
		 * != null) {
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEvento--" +
		 * Utilities.obtenerCadena( "El id de solicitud es ", solicitud
		 * .getIdSolicitud056() .toString()));
		 * 
		 * solicitud.setEstadoSolicitud056(EstadosSolicitud.PROCESADA .name());
		 * this.solicAperturaDao.updateEstado(solicitud);
		 * 
		 * StringBuilder auditUser = new StringBuilder();
		 * 
		 * auditUser.append(contextSubmission.getSenderID());
		 * auditUser.append("#");
		 * auditUser.append(contextSubmission.getSenderName());
		 * auditUser.append("#"); auditUser.append(Constantes.APLICACION);
		 * 
		 * // auditUser.append("44150102S#ITZIAR#AB04A");
		 * 
		 * // Miramos cuantos documentos tenemos en BD DocumentoAperturas
		 * docSoli = new DocumentoAperturas(); docSoli.setTramiteAperturas(new
		 * TramiteAperturas(idTramite)); List<DocumentoAperturas> listaDocsBD =
		 * this.documentoAperturasDao .findAll(docSoli, null);
		 * 
		 * // Consultamos a Dokusi los documentos de la solicitud
		 * T65BDocumentIDListType t65BDocumentIDListType = null; int
		 * consultaDokusi = 1; do { ConsolidarEventoServiceImpl.LOGGER
		 * .info("consolidarEvento--" + Utilities.obtenerCadena(
		 * "En base de datos hay ", Integer.toString(listaDocsBD .size()),
		 * " documentos.")); // sleep ConsolidarEventoServiceImpl.LOGGER
		 * .info("consolidarEvento--" + Utilities .obtenerCadena(
		 * "Dormimos la ejecución 5seg para dar tiempo a los documentos de Dokusi"
		 * ));
		 * 
		 * Thread.sleep(5000);
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEvento--" +
		 * Utilities .obtenerCadena("Reanudamos la ejecución"));
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEvento--" +
		 * Utilities .obtenerCadena( "Consulta de documentos a Dokusi número ",
		 * Integer.toString(consultaDokusi))); try { t65BDocumentIDListType =
		 * this.dokusiService .recuperarDocumentosSolicitud(auditUser
		 * .toString(), contextSubmission .getRegistryNumber(),
		 * contextSubmission.getProcedureID());
		 * 
		 * } catch (Exception e) { ConsolidarEventoServiceImpl.LOGGER .error(
		 * "consolidarEvento--Error al recuperarDocumentosSolicitud en Dokusi Num Reg= "
		 * + contextSubmission .getRegistryNumber() + " . Lo Reintentamos. " +
		 * e.getMessage()); }
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEvento--" +
		 * Utilities .obtenerCadena( "Hemos obtenido de dokusi ",
		 * Integer.toString(t65BDocumentIDListType .getDocumentID() .size()),
		 * " documentos.")); consultaDokusi++; } while
		 * (t65BDocumentIDListType.getDocumentID().size() < listaDocsBD .size()
		 * && consultaDokusi <= ConstantesNum.NUM_5); // Si obtenemos menos
		 * documentos que los que hay en BD, // volvemos // a dormir y volvemos
		 * a consultar if (t65BDocumentIDListType != null &&
		 * t65BDocumentIDListType.getDocumentID() != null &&
		 * !t65BDocumentIDListType.getDocumentID() .isEmpty()) { for
		 * (T65BDocumentIDType doc : t65BDocumentIDListType .getDocumentID()) {
		 * 
		 * // Recuperamos la información del documento a partir // de // su OID
		 * DocumentoAperturas docAux = new DocumentoAperturas();
		 * docAux.setOidDokusi065(doc.getId()); // pasamos ruta PIF para
		 * descargar el fichero de // Dokusi
		 * docAux.setRutaPif065(this.appConfiguration
		 * .getProperty(PropertiesUtil.PIF_RUTA_APP)); //
		 * docAux.setVer(doc.getVersion()); T65BStringListType
		 * t65BStringListType = new T65BStringListType();
		 * t65BStringListType.getElement().add( ConstantesDokusi.META_NOMBRE);
		 * T65BDocumentType docDokusi = this.dokusiService
		 * .recuperarDocumento(auditUser.toString(), docAux,
		 * t65BStringListType);
		 * 
		 * // Buscamos el documento en BD con el nombre y id // solicitud
		 * DocumentoAperturas docFilter = new DocumentoAperturas();
		 * docFilter.setNombreDoc065(docDokusi
		 * .getAttributeList().getAttribute().get(0) .getValue());
		 * docFilter.setTramiteAperturas(new TramiteAperturas( idTramite));
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEvento--" +
		 * Utilities .obtenerCadena( "Buscando en BD documento  ", docFilter
		 * .getTramiteAperturas() .getIdTramite062() .toString(), " con nombre "
		 * , docFilter .getNombreDoc065())); List<DocumentoAperturas>
		 * listaDocumentos = this.documentoAperturasDao
		 * .buscarPorIdTramiteYMetadatoNombre( docFilter, null); if
		 * (listaDocumentos != null && !listaDocumentos.isEmpty()) { docFilter =
		 * listaDocumentos.get(0);
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEvento--" +
		 * Utilities .obtenerCadena( "El id del documento es ", docFilter
		 * .getIdDocumento065() .toString(), " y se le va a poner el OID ",
		 * doc.getId()));
		 * 
		 * DocumentoAperturas docUpdate = new DocumentoAperturas();
		 * docUpdate.setIdDocumento065(docFilter .getIdDocumento065());
		 * docUpdate.setOidDokusi065(doc.getId()); this.solicDocumentosDaoXA
		 * .updateFilled(docUpdate); } else {
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEvento--" +
		 * Utilities .obtenerCadena("No se ha encontrado el documento en BD!"));
		 * } } } } else { ConsolidarEventoServiceImpl.LOGGER
		 * .info("consolidarEvento--" +
		 * "No se ha encontrado la solicitud de eres asociada al evento."); } }
		 * else { ConsolidarEventoServiceImpl.LOGGER .info("consolidarEvento--"
		 * + "El procedure Id no corresponde ni a Eres ni a Huelgas."); } }
		 * catch (Exception e) { throw new AB04BException(e, e.getMessage()); }
		 */
		// TODO PRUEBAS
		// // Actualizamos la solicitud
		// ConsolidarEventoServiceImpl.LOGGER.info("consolidarEventoFront -- "
		// + Utilities.obtenerCadena("El número de registro es ",
		// contextSubmission.getRegistryNumber()));
		//
		// SolicAperturas solicitud = this.solicAperturaDao
		// .findSolicitud(contextSubmission.getRegistryNumber());
		// if (solicitud != null) {
		//
		// ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--"
		// + Utilities.obtenerCadena("El id de solicitud es ",
		// solicitud.getIdSolicitud056().toString()));
		// solicitud.setEstadoSolicitud056(EstadosSolicitud.PROCESADA.name());
		// this.solicAperturaDao.updateEstado(solicitud);
		// }
		// DocumentoAperturas docFilter = new DocumentoAperturas();
		// docFilter.setTramiteAperturas(new TramiteAperturas(idTramite));
		// List<DocumentoAperturas> lista = this.documentoAperturasDao.findAll(
		// docFilter, null);
		// for (DocumentoAperturas doc : lista) {
		// doc.setOidDokusi065("09f424018075fa8b");
		// this.documentoAperturasDao.updateOidDokusi(doc);
		// }
		// // FIN TODO PRUEBAS
		// ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--" +
		// "Fin");

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab04b.service.ConsolidarEventoService#
	 * consolidarEventoSolTelematicaOS2(com.ejie.foldermanagement.xml.
	 * ContextSubmissionEvent, java.lang.Long)
	 */
	@Override()
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED, rollbackFor = Throwable.class, timeout = ConsolidarEventoServiceImpl.TRANSACTION_TIMEOUT)
	public void consolidarEventoSolTelematicaOS2(
			ContextSubmissionEvent contextSubmission, Long idTramite)
			throws AB04BException {
		/*
		 * try { ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--" +
		 * Utilities.obtenerCadena("El procedureId es ",
		 * contextSubmission.getProcedureID()));
		 * 
		 * this.initXaTransaction();
		 * 
		 * // Dormimos la ejecución porque en ocasiones el evento R02_REQUEST //
		 * llega // antes que la respuesta de Platea y en ese caso hará la
		 * consulta // findSolicitudByNumRegistro antes de que la L61A haya
		 * guardado el // número de registro en la tabla de Solicitudes, por lo
		 * que no // encontrará ninguna fila que corresponda al número de
		 * registro del // evento
		 * 
		 * Thread.sleep(ConsolidarEventoServiceImpl.SLEEP_PLATEA_NUM_REG,
		 * ConsolidarEventoServiceImpl.MILIS_IN_A_MINUTE);
		 * 
		 * if (contextSubmission.getProcedureID().equals(
		 * Utilities.getInstance().obtenerDaProcedureIdOs2())) {
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEventoFront -- "
		 * + "Es procedure os2");
		 * 
		 * // Actualizamos la solicitud ConsolidarEventoServiceImpl.LOGGER
		 * .info( "consolidarEventoFront -- " + Utilities .obtenerCadena(
		 * "El número de registro es ", contextSubmission.getRegistryNumber()));
		 * 
		 * SolicOS2 solicitud = this.solicOS2Dao
		 * .findSolicitud(contextSubmission.getRegistryNumber()); if (solicitud
		 * != null) {
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--" +
		 * Utilities.obtenerCadena("El id de solicitud es ",
		 * solicitud.getIdSolicitud060().toString()));
		 * 
		 * solicitud.setEstadoSolicitud060( EstadosSolicitud.PROCESADA.name());
		 * this.solicOS2Dao.updateEstado(solicitud);
		 * 
		 * StringBuilder auditUser = new StringBuilder();
		 * 
		 * auditUser.append(contextSubmission.getSenderID());
		 * auditUser.append("#");
		 * auditUser.append(contextSubmission.getSenderName());
		 * auditUser.append("#"); auditUser.append(Constantes.APLICACION);
		 * 
		 * // Miramos cuantos documentos tenemos en BD DocumentoOS2 docSoli =
		 * new DocumentoOS2(); docSoli.setTramiteOS2(new TramiteOS2(idTramite));
		 * List<DocumentoOS2> listaDocsBD = this.documentoOS2Dao
		 * .findAll(docSoli, null);
		 * 
		 * // Consultamos a Dokusi los documentos de la solicitud
		 * T65BDocumentIDListType t65BDocumentIDListType = null; int
		 * consultaDokusi = 1; do { ConsolidarEventoServiceImpl.LOGGER
		 * .info("consolidarEvento--" + Utilities .obtenerCadena(
		 * "En base de datos hay ", Integer.toString( listaDocsBD.size()),
		 * " documentos.")); // sleep ConsolidarEventoServiceImpl.LOGGER.info(
		 * "consolidarEvento--" + Utilities.obtenerCadena(
		 * "Dormimos la ejecución 5seg para dar tiempo a los documentos de Dokusi"
		 * ));
		 * 
		 * Thread.sleep(5000);
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER.info( "consolidarEvento--" +
		 * Utilities.obtenerCadena( "Reanudamos la ejecución"));
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER.info( "consolidarEvento--" +
		 * Utilities.obtenerCadena( "Consulta de documentos a Dokusi número ",
		 * Integer.toString(consultaDokusi))); try { t65BDocumentIDListType =
		 * this.dokusiService .recuperarDocumentosSolicitud(
		 * auditUser.toString(), contextSubmission .getRegistryNumber(),
		 * contextSubmission.getProcedureID()); } catch (Exception e) {
		 * ConsolidarEventoServiceImpl.LOGGER .error(
		 * "consolidarEvento--Error al recuperarDocumentosSolicitud en Dokusi Num Reg= "
		 * + contextSubmission .getRegistryNumber() + " . Lo Reintentamos. " +
		 * e.getMessage()); }
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER.info( "consolidarEvento--" +
		 * Utilities.obtenerCadena( "Hemos obtenido de dokusi ",
		 * Integer.toString(t65BDocumentIDListType .getDocumentID().size()),
		 * " documentos.")); consultaDokusi++; } while
		 * (t65BDocumentIDListType.getDocumentID() .size() < listaDocsBD.size()
		 * || consultaDokusi <= ConstantesNum.NUM_5); // Si obtenemos menos
		 * documentos que los que hay en BD, // volvemos // a dormir y volvemos
		 * a consultar if (t65BDocumentIDListType != null &&
		 * t65BDocumentIDListType.getDocumentID() != null &&
		 * !t65BDocumentIDListType.getDocumentID() .isEmpty()) { for
		 * (T65BDocumentIDType doc : t65BDocumentIDListType .getDocumentID()) {
		 * 
		 * // Recuperamos la información del documento a partir // de // su OID
		 * DocumentoOS2 docAux = new DocumentoOS2();
		 * docAux.setOidDokusi094(doc.getId());
		 * docAux.setRutaPif094(this.appConfiguration
		 * .getProperty(PropertiesUtil.PIF_RUTA_APP)); //
		 * docAux.setVer(doc.getVersion()); T65BStringListType
		 * t65BStringListType = new T65BStringListType();
		 * t65BStringListType.getElement() .add(ConstantesDokusi.META_NOMBRE);
		 * T65BDocumentType docDokusi = this.dokusiService
		 * .recuperarDocumento(auditUser.toString(), docAux,
		 * t65BStringListType);
		 * 
		 * // Buscamos el documento en BD con el nombre y id // solicitud
		 * DocumentoOS2 docFilter = new DocumentoOS2();
		 * docFilter.setNombreDoc094(
		 * docDokusi.getAttributeList().getAttribute() .get(0).getValue());
		 * docFilter.setTramiteOS2(new TramiteOS2(idTramite));
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEvento--" +
		 * Utilities.obtenerCadena( "Buscando en BD documento  ",
		 * docFilter.getTramiteOS2() .getIdTramite092() .toString(),
		 * " con nombre ", docFilter .getNombreDoc094())); List<DocumentoOS2>
		 * listaDocumentos = this.documentoOS2Dao
		 * .buscarPorIdTramiteYMetadatoNombre( docFilter, null); if
		 * (listaDocumentos != null && !listaDocumentos.isEmpty()) { docFilter =
		 * listaDocumentos.get(0);
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEvento--" +
		 * Utilities.obtenerCadena( "El id del documento es ", docFilter
		 * .getIdDocumento094() .toString(), " y se le va a poner el OID ",
		 * doc.getId()));
		 * 
		 * DocumentoOS2 docUpdate = new DocumentoOS2();
		 * docUpdate.setIdDocumento094( docFilter.getIdDocumento094());
		 * docUpdate.setOidDokusi094(doc.getId()); this.solicDocumentosDaoXA
		 * .updateFilled(docUpdate); } else {
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEvento--" +
		 * Utilities.obtenerCadena( "No se ha encontrado el documento en BD!"));
		 * } } } } else {
		 * ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--" +
		 * "No se ha encontrado la solicitud de eres asociada al evento."); } }
		 * else { ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--" +
		 * "El procedure Id no corresponde ni a Eres ni a Huelgas."); } } catch
		 * (Exception e) { throw new AB04BException(e, e.getMessage()); }
		 */
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab04b.service.ConsolidarEventoService#
	 * consolidarEventoSolTelematicaOS3(com.ejie.foldermanagement.xml.
	 * ContextSubmissionEvent, java.lang.Long)
	 */
	@Override()
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED, rollbackFor = Throwable.class, timeout = ConsolidarEventoServiceImpl.TRANSACTION_TIMEOUT)
	public void consolidarEventoSolTelematicaOS3(
			ContextSubmissionEvent contextSubmission, Long idTramite)
			throws AB04BException {
		/*
		 * try { ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--" +
		 * Utilities.obtenerCadena("El procedureId es ",
		 * contextSubmission.getProcedureID()));
		 * 
		 * this.initXaTransaction();
		 * 
		 * // Dormimos la ejecución porque en ocasiones el evento R02_REQUEST //
		 * llega // antes que la respuesta de Platea y en ese caso hará la
		 * consulta // findSolicitudByNumRegistro antes de que la L61A haya
		 * guardado el // número de registro en la tabla de Solicitudes, por lo
		 * que no // encontrará ninguna fila que corresponda al número de
		 * registro del // evento
		 * 
		 * Thread.sleep(ConsolidarEventoServiceImpl.SLEEP_PLATEA_NUM_REG,
		 * ConsolidarEventoServiceImpl.MILIS_IN_A_MINUTE);
		 * 
		 * if (contextSubmission.getProcedureID().equals(
		 * Utilities.getInstance().obtenerDaProcedureIdOs3())) {
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEventoFront -- "
		 * + "Es procedure os3");
		 * 
		 * // Actualizamos la solicitud ConsolidarEventoServiceImpl.LOGGER
		 * .info("consolidarEventoFront -- " + Utilities .obtenerCadena(
		 * "El número de registro es ", contextSubmission.getRegistryNumber()));
		 * 
		 * SolicOS3 solicitud = this.solicOS3Dao
		 * .findSolicitud(contextSubmission.getRegistryNumber()); if (solicitud
		 * != null) {
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--" +
		 * Utilities.obtenerCadena("El id de solicitud es ",
		 * solicitud.getIdSolicitud061().toString()));
		 * 
		 * solicitud.setEstadoSolicitud061( EstadosSolicitud.PROCESADA.name());
		 * this.solicOS3Dao.updateEstado(solicitud);
		 * 
		 * StringBuilder auditUser = new StringBuilder();
		 * 
		 * auditUser.append(contextSubmission.getSenderID());
		 * auditUser.append("#");
		 * auditUser.append(contextSubmission.getSenderName());
		 * auditUser.append("#"); auditUser.append(Constantes.APLICACION);
		 * 
		 * // Miramos cuantos documentos tenemos en BD DocumentoOS3 docSoli =
		 * new DocumentoOS3(); docSoli.setTramiteOS3(new TramiteOS3(idTramite));
		 * List<DocumentoOS3> listaDocsBD = this.documentoOS3Dao
		 * .findAll(docSoli, null);
		 * 
		 * // Consultamos a Dokusi los documentos de la solicitud
		 * T65BDocumentIDListType t65BDocumentIDListType = null; int
		 * consultaDokusi = 1; do { ConsolidarEventoServiceImpl.LOGGER
		 * .info("consolidarEvento--" + Utilities .obtenerCadena(
		 * "En base de datos hay ", Integer.toString( listaDocsBD.size()),
		 * " documentos.")); // sleep ConsolidarEventoServiceImpl.LOGGER.info(
		 * "consolidarEvento--" + Utilities.obtenerCadena(
		 * "Dormimos la ejecución 5seg para dar tiempo a los documentos de Dokusi"
		 * ));
		 * 
		 * Thread.sleep(5000);
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER.info( "consolidarEvento--" +
		 * Utilities.obtenerCadena( "Reanudamos la ejecución"));
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER.info( "consolidarEvento--" +
		 * Utilities.obtenerCadena( "Consulta de documentos a Dokusi número ",
		 * Integer.toString(consultaDokusi))); try { t65BDocumentIDListType =
		 * this.dokusiService .recuperarDocumentosSolicitud(
		 * auditUser.toString(), contextSubmission .getRegistryNumber(),
		 * contextSubmission.getProcedureID()); } catch (Exception e) {
		 * ConsolidarEventoServiceImpl.LOGGER .error(
		 * "consolidarEvento--Error al recuperarDocumentosSolicitud en Dokusi Num Reg= "
		 * + contextSubmission .getRegistryNumber() + " . Lo Reintentamos. " +
		 * e.getMessage()); }
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER.info( "consolidarEvento--" +
		 * Utilities.obtenerCadena( "Hemos obtenido de dokusi ",
		 * Integer.toString(t65BDocumentIDListType .getDocumentID().size()),
		 * " documentos.")); consultaDokusi++; } while
		 * (t65BDocumentIDListType.getDocumentID() .size() < listaDocsBD.size()
		 * || consultaDokusi <= ConstantesNum.NUM_5); // Si obtenemos menos
		 * documentos que los que hay en BD, // volvemos // a dormir y volvemos
		 * a consultar if (t65BDocumentIDListType != null &&
		 * t65BDocumentIDListType.getDocumentID() != null &&
		 * !t65BDocumentIDListType.getDocumentID() .isEmpty()) { for
		 * (T65BDocumentIDType doc : t65BDocumentIDListType .getDocumentID()) {
		 * 
		 * // Recuperamos la información del documento a partir // de // su OID
		 * DocumentoOS3 docAux = new DocumentoOS3();
		 * docAux.setOidDokusi097(doc.getId());
		 * docAux.setRutaPif097(this.appConfiguration
		 * .getProperty(PropertiesUtil.PIF_RUTA_APP)); //
		 * docAux.setVer(doc.getVersion()); T65BStringListType
		 * t65BStringListType = new T65BStringListType();
		 * t65BStringListType.getElement() .add(ConstantesDokusi.META_NOMBRE);
		 * T65BDocumentType docDokusi = this.dokusiService
		 * .recuperarDocumento(auditUser.toString(), docAux,
		 * t65BStringListType);
		 * 
		 * // Buscamos el documento en BD con el nombre y id // solicitud
		 * DocumentoOS3 docFilter = new DocumentoOS3();
		 * docFilter.setNombreDoc097(
		 * docDokusi.getAttributeList().getAttribute() .get(0).getValue());
		 * docFilter.setTramiteOS3(new TramiteOS3(idTramite));
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEvento--" +
		 * Utilities.obtenerCadena( "Buscando en BD documento  ",
		 * docFilter.getTramiteOS3() .getIdTramite095() .toString(),
		 * " con nombre ", docFilter .getNombreDoc097())); List<DocumentoOS3>
		 * listaDocumentos = this.documentoOS3Dao
		 * .buscarPorIdTramiteYMetadatoNombre( docFilter, null); if
		 * (listaDocumentos != null && !listaDocumentos.isEmpty()) { docFilter =
		 * listaDocumentos.get(0);
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEvento--" +
		 * Utilities.obtenerCadena( "El id del documento es ", docFilter
		 * .getIdDocumento097() .toString(), " y se le va a poner el OID ",
		 * doc.getId()));
		 * 
		 * DocumentoOS3 docUpdate = new DocumentoOS3();
		 * docUpdate.setIdDocumento097( docFilter.getIdDocumento097());
		 * docUpdate.setOidDokusi097(doc.getId()); this.solicDocumentosDaoXA
		 * .updateFilled(docUpdate); } else {
		 * 
		 * ConsolidarEventoServiceImpl.LOGGER .info("consolidarEvento--" +
		 * Utilities.obtenerCadena( "No se ha encontrado el documento en BD!"));
		 * } } } } else {
		 * ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--" +
		 * "No se ha encontrado la solicitud de eres asociada al evento."); } }
		 * else { ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--" +
		 * "El procedure Id no corresponde ni a Eres ni a Huelgas."); } } catch
		 * (Exception e) { throw new AB04BException(e, e.getMessage()); }
		 */

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab04b.service.ConsolidarEventoService#
	 * consolidarEventoSolPresencialApertura(com.ejie.foldermanagement.xml.
	 * ContextSubmissionEvent, java.lang.Long)
	 */
	@Override()
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED, rollbackFor = Throwable.class, timeout = ConsolidarEventoServiceImpl.TRANSACTION_TIMEOUT)
	public void consolidarEventoSolPresencialApertura(
			ContextSubmissionEvent contextSubmission, Long idTramite)
			throws AB04BException {

		try {
			ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--"
					+ Utilities.obtenerCadena("El procedureId es ",
							contextSubmission.getProcedureID()));

			this.initXaTransaction();

			if (contextSubmission.getProcedureID().equals(
					Utilities.getInstance().obtenerProcedureIdApertura())) {

				String folderId = contextSubmission.getFolderID();

				ComunicacionApertura apertura = this.comunicacionAperturaService
						.findByFolderId(folderId);

				// recoger de la tabla temporal
				DocumentoAperturas docFilter = new DocumentoAperturas();
				docFilter.setIdapetemp065(apertura.getIdape056());
				List<DocumentoAperturas> listaDocumentosAperturasTemp = this.documentosAperturasTempDao
						.buscarDocumentosAperturasTempIdApe(docFilter);

				if (listaDocumentosAperturasTemp != null
						&& listaDocumentosAperturasTemp.size() > 0) {

					// recoger de la tabla temporal
					docFilter = new DocumentoAperturas();
					docFilter.setIdapetemp065(apertura.getIdape056());

					// borrar los temporales
					this.documentosAperturasTempDao
							.removeByIdApertura(docFilter);

				} else {
					ConsolidarEventoServiceImpl.LOGGER
							.info("consolidarEvento--"
									+ "No se ha encontrado la solicitud de eres asociada al evento.");
				}
			} else {
				ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--"
						+ "El procedure Id no corresponde a una Apertura.");
			}
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab04b.service.ConsolidarEventoService#
	 * consolidarEventoSolPresencialOS2(com.ejie.foldermanagement.xml.
	 * ContextSubmissionEvent, java.lang.Long)
	 */
	@Override()
	public void consolidarEventoSolPresencialOS2(
			ContextSubmissionEvent contextSubmission, Long idTramite)
			throws AB04BException {

		try {
			ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--"
					+ Utilities.obtenerCadena("El procedureId es ",
							contextSubmission.getProcedureID()));

			this.initXaTransaction();

			if (contextSubmission.getProcedureID().equals(
					Utilities.getInstance().obtenerProcedureIdOs2())) {

				String folderId = contextSubmission.getFolderID();

				OS2 os2 = this.os2Service.findByFolderId(folderId);

				// recoger de la tabla temporal
				DocumentoOS2 docFilter = new DocumentoOS2();
				docFilter.setTramiteOS2(new TramiteOS2(null, null, os2));
				List<DocumentoOS2> listaDocumentosOS2Temp = this.documentosOS2TempDao
						.buscarDocumentosOS2Temp(docFilter);

				if (listaDocumentosOS2Temp != null
						&& listaDocumentosOS2Temp.size() > 0) {

					// recoger de la tabla temporal
					docFilter = new DocumentoOS2();
					docFilter.setTramiteOS2(new TramiteOS2(null, null, os2));

					// borrar los temporales
					this.documentosOS2TempDao.removeByIdApertura(docFilter);

				} else {
					ConsolidarEventoServiceImpl.LOGGER
							.info("consolidarEvento--"
									+ "No se ha encontrado la solicitud de eres asociada al evento.");
				}
			} else {
				ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--"
						+ "El procedure Id no corresponde a un OS2.");
			}
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab04b.service.ConsolidarEventoService#
	 * consolidarEventoSolPresencialOS3(com.ejie.foldermanagement.xml.
	 * ContextSubmissionEvent, java.lang.Long)
	 */
	@Override()
	public void consolidarEventoSolPresencialOS3(
			ContextSubmissionEvent contextSubmission, Long idTramite)
			throws AB04BException {
		try {
			ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--"
					+ Utilities.obtenerCadena("El procedureId es ",
							contextSubmission.getProcedureID()));

			this.initXaTransaction();

			if (contextSubmission.getProcedureID().equals(
					Utilities.getInstance().obtenerProcedureIdOs3())) {

				String folderId = contextSubmission.getFolderID();

				OS3 os3 = this.os3Service.findByFolderId(folderId);

				// recoger de la tabla temporal
				DocumentoOS3 docFilter = new DocumentoOS3();
				docFilter.setTramiteOS3(new TramiteOS3(null, null, os3));
				List<DocumentoOS3> listaDocumentosOS3Temp = this.documentosOS3TempDao
						.buscarDocumentosOS3Temp(docFilter);

				if (listaDocumentosOS3Temp != null
						&& listaDocumentosOS3Temp.size() > 0) {

					// recoger de la tabla temporal
					docFilter = new DocumentoOS3();
					docFilter.setTramiteOS3(new TramiteOS3(null, null, os3));

					// borrar los temporales
					this.documentosOS3TempDao.removeByIdApertura(docFilter);

				} else {
					ConsolidarEventoServiceImpl.LOGGER
							.info("consolidarEvento--"
									+ "No se ha encontrado la solicitud de eres asociada al evento.");
				}
			} else {
				ConsolidarEventoServiceImpl.LOGGER.info("consolidarEvento--"
						+ "El procedure Id no corresponde a un OS3.");
			}
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/**
	 * Inicializa la transaccion XA.
	 */
	private void initXaTransaction() {
		this.solicAperturaDaoXA.setXA(true);
		this.solicOS2DaoXA.setXA(true);
		this.solicOS3DaoXA.setXA(true);
		this.solicDocumentosDaoXA.setXA(true);
	}

}
